defmodule EthBlockchain.MixProject do
  use Mix.Project

  def project do
    [
      app: :eth_blockchain,
      version: "2.0.0-dev",
      build_path: "../../_build",
      config_path: "../../config/config.exs",
      deps_path: "../../deps",
      lockfile: "../../mix.lock",
      elixir: "~> 1.8",
      elixirc_paths: elixirc_paths(Mix.env),
      start_permanent: Mix.env() == :prod,
      deps: deps()
    ]
  end

  # Run "mix help compile.app" to learn about applications.
  def application do
    [
      extra_applications: [:logger],
      mod: {EthBlockchain.Application, []}
    ]
  end

  # Specifies which paths to compile per environment.
  defp elixirc_paths(:test), do: ["lib", "test/support"]
  defp elixirc_paths(_),     do: ["lib"]

  # Run "mix help deps" to learn about dependencies.
  defp deps do
    [
      {:exth_crypto, "~> 0.1.6"},
      {:ex_rlp, "~> 0.5.2"},
      {:utils, in_umbrella: true},
      {:keychain, in_umbrella: true}
    ]
  end
end
