use Mix.Config

config :ewallet_api, EWalletAPI.V1.Endpoint,
  debug_errors: true,
  check_origin: false

# Config for node discovery.
config :peerage,
  via: Peerage.Via.Dns,
  dns_name: {:system, "NODE_DNS", "localhost"},
  app_name: "ewallet"

# For production, we often load configuration from external
# sources, such as your system environment. For this reason,
# you won't find the :http configuration below, but set inside
# EWalletAPI.Endpoint.init/2 when load_from_system_env is
# true. Any dynamic configuration should be done there.

# ## SSL Support
#
# To get SSL working, you will need to add the `https` key
# to the previous section and set your `:url` port to 443:
#
#     config :ewallet_api, EWalletAPI.Endpoint,
#       ...
#       url: [host: "example.com", port: 443],
#       https: [:inet6,
#               port: 443,
#               keyfile: System.get_env("SOME_APP_SSL_KEY_PATH"),
#               certfile: System.get_env("SOME_APP_SSL_CERT_PATH")]
#
# Where those two env variables return an absolute path to
# the key and cert in disk or a relative path inside priv,
# for example "priv/ssl/server.key".
#
# We also recommend setting `force_ssl`, ensuring no data is
# ever sent via http, always redirecting to https:
#
#     config :ewallet_api, EWalletAPI.Endpoint,
#       force_ssl: [hsts: true]
#
# Check `Plug.SSL` for all available options in `force_ssl`.

# ## Using releases
#
# If you are doing OTP releases, you need to instruct Phoenix
# to start the server for all endpoints:
#
#     config :phoenix, :serve_endpoints, true
#
# Alternatively, you can configure exactly which server to
# start per endpoint:
#
#     config :ewallet_api, EWalletAPI.Endpoint, server: true
#
