defmodule EWalletConfig.MixProject do
  use Mix.Project

  def project do
    [
      app: :ewallet_config,
      version: "2.0.0-dev",
      build_path: "../../_build",
      config_path: "../../config/config.exs",
      deps_path: "../../deps",
      lockfile: "../../mix.lock",
      elixir: "~> 1.8",
      elixirc_paths: elixirc_paths(Mix.env()),
      start_permanent: Mix.env() == :prod,
      test_coverage: [tool: ExCoveralls],
      preferred_cli_env: [
        coveralls: :test,
        "coveralls.detail": :test,
        "coveralls.post": :test,
        "coveralls.html": :test
      ],
      aliases: aliases(),
      deps: deps()
    ]
  end

  # Specifies which paths to compile per environment.
  defp elixirc_paths(:test), do: ["lib", "test/support"]
  defp elixirc_paths(_), do: ["lib"]

  # Run "mix help compile.app" to learn about applications.
  def application do
    [
      extra_applications: [:appsignal, :logger],
      mod: {EWalletConfig.Application, []},
    ]
  end

  # Run "mix help deps" to learn about dependencies.
  defp deps do
    [
      {:activity_logger, in_umbrella: true},
      {:appsignal, "~> 1.9"},
      {:arc, "~> 0.11.0"},
      {:arc_ecto, github: "omisego/arc_ecto"},
      {:bcrypt_elixir, "~> 1.0"},
      {:cloak, "~> 0.9.1"},
      {:db, in_umbrella: true},
      {:deferred_config, "~> 0.1.0"},
      {:ecto_sql, "~> 3.0"},
      {:plug, "~> 1.0"},
      {:poison, "~> 3.1"},
      {:postgrex, ">= 0.0.0"},
      {:utils, in_umbrella: true},

      # arc GCS dependencies
      {:arc_gcs, github: "omisego/arc_gcs"},

      # arc AWS dependencies
      {:ex_aws, "~> 2.0"},
      {:ex_aws_s3, "~> 2.0"},
      {:hackney, "~> 1.6"},
      {:sweet_xml, "~> 0.6"},

      # Quantum scheduler dependencies
      {:quantum, ">= 2.2.6"},
      {:timex, "~> 3.0"},
    ]
  end

  # Aliases are shortcuts or tasks specific to the current project.
  # For example, to create, migrate and run the seeds file at once:
  #
  #     $ mix ecto.setup
  #
  # See the documentation for `Mix` for more info on aliases.
  defp aliases do
    [
      "ecto.setup": ["ecto.create", "ecto.migrate"],
      "ecto.reset": ["ecto.drop", "ecto.setup"],
      test: ["ecto.create --quiet", "ecto.migrate", "test"]
    ]
  end
end
