import React, { Component } from 'react'
import PropTypes from 'prop-types'
import styled from 'styled-components'
import moment from 'moment'
import { Link, withRouter } from 'react-router-dom'

import { formatReceiveAmountToTotal, formatNumber } from '../utils/formatter'

const InformationItem = styled.div`
  color: ${props => props.theme.colors.B200};
  :not(:last-child) {
    margin-bottom: 10px;
  }
  span {
    vertical-align: bottom;
  }
`
const AdditionalRequestDataContainer = styled.div`
  > div {
    margin-bottom: 10px;
  }
  h5 {
    margin-bottom: 10px;
    letter-spacing: 1px;
  }
`
export default withRouter(
  class TransactionRequestDetail extends Component {
    static propTypes = {
      transactionRequest: PropTypes.object,
      location: PropTypes.object
    }

    render = () => {
      const tq = this.props.transactionRequest
      const amount =
        tq.amount === null ? (
          'Not Specified'
        ) : (
          <span>
            {formatReceiveAmountToTotal(tq.amount, _.get(tq, 'token.subunit_to_unit'))} {_.get(tq, 'token.symbol')}
          </span>
        )
      return (
        <AdditionalRequestDataContainer>
          <h5>ADDITIONAL REQUEST DETAILS</h5>
          <InformationItem>
            <b>ID :</b> {tq.id}
          </InformationItem>
          <InformationItem>
            <b>Type :</b> {tq.type}
          </InformationItem>
          <InformationItem>
            <b>Token:</b> {_.get(tq, 'token.name')}
          </InformationItem>
          <InformationItem>
            <b>Amount :</b> {amount}
          </InformationItem>
          <InformationItem>
            <b>Requester Address : </b>
            <Link
              to={{
                pathname: `/accounts/${tq.account_id}/wallets/${tq.address}`,
                search: this.props.location.search
              }}
            >
              {tq.address}
            </Link>
          </InformationItem>
          <InformationItem>
            <b>Account ID : </b>
            {_.get(tq, 'account.id') ? (
              <Link
                to={{
                  pathname: `/accounts/${tq.account.id}/details`,
                  search: this.props.location.search
                }}
              >
                {_.get(tq, 'account.id')}
              </Link>
            ) : (
              '-'
            )}
          </InformationItem>
          <InformationItem>
            <b>Account Name : </b>
            {_.get(tq, 'account.id') ? (
              <Link
                to={{
                  pathname: `/accounts/${tq.account.id}/details`,
                  search: this.props.location.search
                }}
              >
                {' '}
                {_.get(tq, 'account.name')}{' '}
              </Link>
            ) : (
              '-'
            )}
          </InformationItem>
          <InformationItem>
            <b>Exchange Account Name : </b>
            {_.get(tq, 'exchange_account.id') ? (
              <Link
                to={{
                  pathname: `/accounts/${tq.exchange_account.id}/details`,
                  search: this.props.location.search
                }}
              >
                {_.get(tq, 'exchange_account.name')}
              </Link>
            ) : (
              '-'
            )}
          </InformationItem>
          <InformationItem>
            <b>Exchange Account ID : </b>
            {_.get(tq, 'exchange_account.id') ? (
              <Link
                to={{
                  pathname: `/accounts/${tq.exchange_account.id}/details`,
                  search: this.props.location.search
                }}
              >
                {tq.exchange_account.id}
              </Link>
            ) : (
              '-'
            )}
          </InformationItem>
          <InformationItem>
            <b>Exchange Wallet Address : </b>
            {_.get(tq, 'exchange_wallet') ? (
              <Link
                to={{
                  pathname: `/accounts/${tq.account_id}/wallets/${_.get(tq, 'exchange_wallet.address')}`,
                  search: this.props.location.search
                }}
              >
                {tq.exchange_wallet.address}
              </Link>
            ) : (
              '-'
            )}
          </InformationItem>
          <InformationItem>
            <b>User ID : </b>
            {_.get(tq, 'user.id') ? <Link to={`/users/${_.get(tq, 'user.id')}`}>{tq.user.id}</Link> : '-'}
          </InformationItem>
          <InformationItem>
            <b>Confirmation : </b> {tq.require_confirmation ? 'Yes' : 'No'}
          </InformationItem>
          <InformationItem>
            <b>Consumptions Count : </b> {formatNumber(tq.current_consumptions_count)}
          </InformationItem>
          <InformationItem>
            <b>Max Consumptions : </b> {tq.max_consumptions ? formatNumber(tq.max_consumptions) : '-'}
          </InformationItem>
          <InformationItem>
            <b>Max Consumptions Per User : </b> {tq.max_consumptions_per_user ? formatNumber(tq.max_consumptions_per_user) : '-'}
          </InformationItem>
          <InformationItem>
            <b>Consumption Life Time : </b>
            {tq.consumption_lifetime ? `${formatNumber(tq.consumption_lifetime)} ms` : '-'}
          </InformationItem>
          <InformationItem>
            <b>Consumption Interval Duration : </b>
            {tq.consumption_interval_duration ? `${formatNumber(tq.consumption_interval_duration)} ms` : '-'}
          </InformationItem>
          <InformationItem>
            <b>Max Consumption Per Interval : </b>
            {tq.max_consumptions_per_interval ? formatNumber(tq.max_consumptions_per_interval) : '-'}
          </InformationItem>
          <InformationItem>
            <b>Max Consumption Per Interval Per User : </b>
            {tq.max_consumptions_per_interval_per_user ? formatNumber(tq.max_consumptions_per_interval_per_user) : '-'}
          </InformationItem>

          <InformationItem>
            <b>Expiry Date : </b> {tq.expiration_date ? moment(tq.expiration_date).format() : '-'}
          </InformationItem>
          <InformationItem>
            <b>Allow Amount Override : </b> {tq.allow_amount_override ? 'Yes' : 'No'}
          </InformationItem>
          <InformationItem>
            <b>Correlation ID : </b> {tq.correlation_id || '-'}
          </InformationItem>
        </AdditionalRequestDataContainer>
      )
    }
  }
)
