# Entities

- __Tokens__: A currency (loyalty points, cryptocurrency, tokenized fiat). Identified by a symbol (OMG, BTC, USDT). By default, a token is not backed by the blockchain, which means a provider can only make internal transfers, between the provider's wallets and the users wallets (back and forth) or between accounts. If a provider wishes to have one of its token backed, the address of the smart contract on the blockchain needs to be defined in the token details to uniquely identify it.

- __Mints__: A record of each occurrence when more tokens were put into circulation.

- __Accounts__: A grouping of users and wallets. It can be used by a provider admin to define logical groupings according to its business needs, e.g. an account for each product branding, each store branch, each sales team or each operating region, etc.

- __Users__: A user can either be a regular user or a staff user (a.k.a admin) In the first case, it would be someone using the end-user applications created by providers (mobile applications for example), who was added to the eWallet database by the provider. In the second case, it's a user able to access the OmiseGO admin panel.

- __Wallets__: A balance identified by an address which is used to group transactions and holds a value. A user can have more than one balance if needed, and a balance can contain different currencies. You can learn more about wallets [there](/docs/design/wallets.md).

- __Transactions__: A transaction is an exchange of value between two wallets. Transactions are stored in the local ledger using a DEB approach. DEB (Double Entry Bookkeeping) is a system where an entry is created and DEBIT/CREDIT transactions are linked to it. The sum of all debits minus the sum of all credits for a specific entry has to be equal to 0. Summing up all credit transactions minus all debit transactions for a specific balance address and token symbol gives the balance of that address.

- __Access Key__: An identifying pair of keys (access/secret) used by a provider's server application to communicate with eWallet. A combination is used here instead of a single key to prevent timing- based attacks.

- __Secret Key__: A secret key acting as a password and sent from a provider's backend application to authenticate requests.

- __API Key__: A perishable key sent from a mobile applications to make authenticated non-sensitive API calls to eWallet.

- __Access Token__: A temporary token generated by the eWallet API and returned through a provider's backend application to the client. It can then be used with an API key to make non-sensitive calls to eWallet.
