# Upgrading from `v1.0.0` to `v1.1.0`

## Prerequisites

Please perform the upgrade as described in [Upgrading the eWallet Server](README.md)
before proceeding below.

## Instructions

Numerous settings have been moved from environment variables to the database for ease of editing
and maintenance. Execute the command below after deployment to migrate your current settings.

```shell
bin/ewallet config --migrate

# or `mix omg.config --migrate` on development environment
```

You will be prompted to confirm the settings to be migrated. To execute the migration
without a confirmation, execute the command with `--yes`.

Although the migrated environment variables will no longer have effects on the system,
we recommend you to remove those variables to avoid future conflicts or confusions.

## Changes to the maintenance commands

We have switched our deployment from using Mix (development tools) directly in
production environment to Distillery, which resulted in a smaller footprint for our release.

The maintenance commands have changed from `v1.0.0` to `v1.1.0`, as follows:

- `mix do local.hex, local.rebar` -> no longer needed
- `mix ecto.create` -> `bin/ewallet initdb`
- `mix ecto.migrate` -> `bin/ewallet initdb`
- `mix omg.seed` -> `bin/ewallet seed`
- `mix omg.server` -> `bin/ewallet foreground`
- `iex -S mix` -> `bin/ewallet console`
